<?php
include 'conexao.php';

// Buscar turmas anteriores
$turmas = [];
$res = $conn->query("SELECT * FROM turmas_anteriores ORDER BY ano DESC, nome ASC");
while ($row = $res->fetch_assoc()) {
    $turmas[] = $row;
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Ver Alunos de Turmas Anteriores</title>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
        }
        .top-bar {
            background: #0056b3;
            color: white;
            padding: 15px;
            font-size: 18px;
        }
        .sidebar {
            width: 220px;
            background: #1c1c1c;
            height: 100vh;
            float: left;
            padding-top: 20px;
        }
        .sidebar a {
            display: block;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
        }
        .sidebar a:hover {
            background: #333;
        }
        .content {
            margin-left: 220px;
            padding: 20px;
            background: #f4f4f4;
            min-height: 100vh;
        }
        .form-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 5px #ccc;
            max-width: 600px;
            margin-bottom: 20px;
        }
        select, button {
            padding: 8px;
            margin-top: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: left;
        }
        th {
            background: #ddd;
        }
        .nav-links {
            margin-top: 10px;
        }
        .nav-links a {
            margin-right: 10px;
            color: #0056b3;
            text-decoration: none;
        }
        .nav-links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<div class="top-bar">SISMAG - Ver Alunos das Turmas de Anos Anteriores</div>

<div class="sidebar">
    <a href="painel_anteriores.php">🏠 Início</a>
    <a href="cadastrar_turma_anterior.php">🏫 Cadastrar Turmas</a>
    <a href="cadastrar_aluno_anterior.php">👨‍🎓 Cadastrar Aluno</a>
    <a href="cadastrar_disciplina_anterior.php">📚 Cadastrar Disciplinas</a>
</div>

<div class="content">
    <div class="form-box">
        <h2>Selecionar Turma</h2>
        <form method="GET">
            <label>Turma:</label><br>
            <select name="turma_id" required>
                <option value="">-- Selecionar --</option>
                <?php foreach ($turmas as $turma): ?>
                    <option value="<?= $turma['id'] ?>" <?= isset($_GET['turma_id']) && $_GET['turma_id'] == $turma['id'] ? 'selected' : '' ?>>
                        <?= $turma['nome'] ?> (<?= $turma['ano'] ?>)
                    </option>
                <?php endforeach; ?>
            </select>
            <br><br>
            <button type="submit">Ver</button>
        </form>
    </div>

    <div class="nav-links">
        <a href="cadastrar_aluno_anterior.php">➕ Cadastrar Novo Aluno</a>
    </div>

    <?php
    if (isset($_GET['turma_id']) && $_GET['turma_id'] !== '') {
        $turma_id = $_GET['turma_id'];
        $res = $conn->query("SELECT * FROM alunos WHERE turma_id = $turma_id AND origem = 'anterior' ORDER BY nome");

        if ($res->num_rows > 0) {
            echo "<h3>Lista de Alunos da Turma</h3>";
            echo "<table>";
            echo "<tr><th>#</th><th>Nome</th><th>Idade</th><th>Género</th></tr>";
            $i = 1;
            while ($aluno = $res->fetch_assoc()) {
                echo "<tr>
                        <td>$i</td>
                        <td>{$aluno['nome']}</td>
                        <td>{$aluno['idade']}</td>
                        <td>{$aluno['genero']}</td>
                      </tr>";
                $i++;
            }
            echo "</table>";
        } else {
            echo "<p><strong>Não há alunos cadastrados para esta turma.</strong></p>";
        }
    }
    ?>
</div>

</body>
</html>
